﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace VishalMonpara.TokenExample
{
	public partial class frmExample : Form
	{
		TokenHelper tokenHelper = new TokenHelper();
		public frmExample()
		{
			InitializeComponent();
		}

		private void frmExample_Load(object sender, EventArgs e)
		{
			txtToken.Text = 
@"Current Date Time: %date{yyyy-MM-dd-HH:mm:ss} 
Yesterday was %yesterday{dddd}
You started this program at %frozendate{yyyy-MM-dd-HH:mm:ss}
You clicked the Calculate button %counter{0} time(s)
Here is my custom token value: %footoken";
			tokenHelper.TokenList.Add(new CurrentDateTimeToken());
			tokenHelper.TokenList.Add(new YesterdayDateTimeToken());
			tokenHelper.TokenList.Add(new LastWeekDateTimeToken());
			tokenHelper.TokenList.Add(new LastMonthDateTimeToken());
			tokenHelper.TokenList.Add(new LastYearDateTimeToken());
			tokenHelper.TokenList.Add(new TextToken("footoken", "bar"));
			tokenHelper.TokenList.Add(new FrozenDateTimeToken());
			tokenHelper.TokenList.Add(new CounterToken(1, 1));
		}

		private void btnCalculate_Click(object sender, EventArgs e)
		{
			txtResult.Text = tokenHelper.ReplaceToken(txtToken.Text);
		}
	}
}
