Public Module Utility
    Public Function GetHTML(ByVal objControl As Control) As String
        Dim sb As New System.Text.StringBuilder
        GenerateHTML(objControl, sb)
        Return sb.ToString
    End Function
    Public Function GetCode(ByVal objControl As Control) As String
        Dim sb As New System.Text.StringBuilder
        sb.Append("Dim sb As New System.Text.StringBuilder")
        GenerateCode(objControl, sb)
        Return sb.ToString
    End Function
    Private Sub GenerateHTML(ByVal objControl As Control, ByVal sb As System.Text.StringBuilder)
        Dim str As New System.Text.StringBuilder
        Dim sw As New System.IO.StringWriter(str)
        Dim hw As New System.Web.UI.HtmlTextWriter(sw)
        If TypeOf (objControl) Is HtmlTable Then
            sb.Append("<table ")
            CType(objControl, HtmlTable).Attributes.Render(hw)
            sb.Append(str.ToString & " >")
            Dim objControl1 As Control
            For Each objControl1 In objControl.Controls
                GenerateHTML(objControl1, sb)
            Next
            sb.Append("</table>")
        ElseIf TypeOf (objControl) Is HtmlTableRow Then
            sb.Append("<tr ")
            CType(objControl, HtmlTableRow).Attributes.Render(hw)
            sb.Append(str.ToString & " >")
            Dim objControl1 As Control
            For Each objControl1 In objControl.Controls
                GenerateHTML(objControl1, sb)
            Next
            sb.Append("</tr>")
        ElseIf TypeOf (objControl) Is HtmlTableCell Then
            sb.Append("<td ")
            CType(objControl, HtmlTableCell).Attributes.Render(hw)
            sb.Append(str.ToString & " >")
            Dim objControl1 As Control
            For Each objControl1 In objControl.Controls
                GenerateHTML(objControl1, sb)
            Next
            sb.Append("</td>")
        ElseIf TypeOf (objControl) Is LiteralControl Then
            sb.Append(CType(objControl, LiteralControl).Text)
        ElseIf TypeOf (objControl) Is TextBox Then
            sb.Append(CType(objControl, TextBox).Text)
        ElseIf TypeOf (objControl) Is Label Then
            sb.Append(CType(objControl, Label).Text)
        ElseIf TypeOf (objControl) Is CheckBox Then
            Dim chk As CheckBox = CType(objControl, CheckBox)
            sb.Append("<input type='checkbox'" & IIf(chk.Checked, "Checked ", " >") & chk.Text)
        ElseIf TypeOf (objControl) Is RadioButton Then
            Dim rad As RadioButton = CType(objControl, RadioButton)
            sb.Append("<input type='radio'" & IIf(rad.Checked, "Checked >", " >") & rad.Text)
        End If
    End Sub
    Private Sub GenerateCode(ByVal objControl As Control, ByVal sb As System.Text.StringBuilder)
        Dim str As New System.Text.StringBuilder
        Dim sw As New System.IO.StringWriter(str)
        Dim hw As New System.Web.UI.HtmlTextWriter(sw)
        If TypeOf (objControl) Is HtmlTable Then
            sb.Append("<br>sb.Append(""&lt;table ")
            CType(objControl, HtmlTable).Attributes.Render(hw)
            sb.Append(str.ToString.Replace("""", "'") & " &gt;"")")
            Dim objControl1 As Control
            For Each objControl1 In objControl.Controls
                GenerateCode(objControl1, sb)
            Next
            sb.Append("<br>sb.Append(""&lt;/table&gt;"")")
        ElseIf TypeOf (objControl) Is HtmlTableRow Then
            sb.Append("<br>sb.Append(""&lt;tr ")
            CType(objControl, HtmlTableRow).Attributes.Render(hw)
            sb.Append(str.ToString.Replace("""", "'") & " &gt;"")")
            Dim objControl1 As Control
            For Each objControl1 In objControl.Controls
                GenerateCode(objControl1, sb)
            Next
            sb.Append("<br>sb.Append(""&lt;/tr&gt;"")")
        ElseIf TypeOf (objControl) Is HtmlTableCell Then
            sb.Append("<br>sb.Append(""&lt;td ")
            CType(objControl, HtmlTableCell).Attributes.Render(hw)
            sb.Append(str.ToString.Replace("""", "'") & " &gt;"")")
            Dim objControl1 As Control
            For Each objControl1 In objControl.Controls
                GenerateCode(objControl1, sb)
            Next
            sb.Append("<br>sb.Append(""&lt;/td&gt;"")")
        ElseIf TypeOf (objControl) Is LiteralControl Then
            sb.Append("<br>sb.Append(""" & CType(objControl, LiteralControl).Text & """)")
        ElseIf TypeOf (objControl) Is TextBox Then
            sb.Append("<br>sb.Append(" & CType(objControl, TextBox).ID & ".Text)")
        ElseIf TypeOf (objControl) Is Label Then
            sb.Append("<br>sb.Append(" & CType(objControl, Label).ID & ".Text)")
        ElseIf TypeOf (objControl) Is CheckBox Then
            Dim chk As CheckBox = CType(objControl, CheckBox)
            sb.Append("<br>sb.Append(""&lt;input type='checkbox'"" & IIf(" & chk.ID & ".Checked,""Checked >"","" >"") & " & chk.ID & ".Text) ")
        ElseIf TypeOf (objControl) Is RadioButton Then
            Dim rad As RadioButton = CType(objControl, RadioButton)
            sb.Append("<br>sb.Append(""&lt;input type='radio'"" & IIf(" & rad.ID & ".Checked,""Checked >"","" >"") & " & rad.ID & ".Text)")
        End If
    End Sub
End Module
