<?php
/*
Plugin Name: Yearly Repeater
Plugin URI: http://blog.vishalon.net/Post/89.aspx
Description: This plugin repeats a particular post every year. Set the custom field REPEATON to MM/DD for the post to repeat. Ex. REPEATON=03/24 will show the post on the top of your blog posts on 24th of March every year.
Author: Vishal Monpara
Version: 1.1
Author URI: http://www.vishalon.net/
*/
add_filter('query','YearlyRepeat');
function YearlyRepeat($query)
{
	global $wpdb;

	if (preg_match('/SELECT SQL_CALC/', $query) && ! preg_match('/ LIKE /', $query)) {
		$uri = $_SERVER['REQUEST_URI'];
		if ((strlen($uri)==1) || (strlen($uri)<=11 && strpos($uri,'index.php')))
		{
			$split = explode('ORDER BY', $query);
			$orderby = 'ORDER BY N,'. $split[1];
			$query = str_replace(' FROM ',', 2 AS N FROM ',$split[0]);
			$query = "(" .$query. ") UNION ALL ";
			$query = $query. 
			"( SELECT $wpdb->posts.*, 1 AS N FROM $wpdb->posts 
				INNER JOIN $wpdb->postmeta
				ON $wpdb->posts.ID = $wpdb->postmeta.post_id
				WHERE $wpdb->posts.post_status = 'publish'
				AND $wpdb->posts.post_type = 'post'
				AND $wpdb->postmeta.meta_key = 'REPEATON' AND $wpdb->postmeta.meta_value = '". gmdate('m/d', time()+(get_settings('gmt_offset') * 3600)) . "'
				ORDER BY $wpdb->posts.post_date_gmt DESC) ".
			$orderby;
		}
	}
	return $query;
}
?>