﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ICSharpCode.SharpZipLib.Zip;

namespace ReplaceAPTCode
{
	public partial class frmMain : Form
	{
		public frmMain()
		{
			InitializeComponent();

		}

		private void Form1_Load(object sender, EventArgs e)
		{
		}

		private void btnSelectFolder_Click(object sender, EventArgs e)
		{
			openFileDialog.ValidateNames = false;
			openFileDialog.CheckFileExists = false;
			openFileDialog.CheckPathExists = true;
			openFileDialog.FileName = "Folder Selection";
			openFileDialog.Filter = "Excel/Word Macro Enabled Files|*.xlsm;*.docm";

			if (openFileDialog.ShowDialog() == System.Windows.Forms.DialogResult.OK)
			{
				txtFolderName.Text = System.IO.Path.GetDirectoryName(openFileDialog.FileName);
			}
		}

		private void btnSelectFile_Click(object sender, EventArgs e)
		{
			openFileDialog.ValidateNames = true;
			openFileDialog.CheckFileExists = true;
			openFileDialog.CheckPathExists = true;
			openFileDialog.FileName = "vbaProject.bin";
			openFileDialog.Filter = "VBA Code|*.bin";
			if (openFileDialog.ShowDialog() == System.Windows.Forms.DialogResult.OK)
			{
				txtFileName.Text = openFileDialog.FileName;
			}
		}

		private void btnUpdateCode_Click(object sender, EventArgs e)
		{
			if (string.IsNullOrEmpty(txtFileName.Text))
			{
				MessageBox.Show("VBA File Path must be provided.");
				return;
			}
			if (string.IsNullOrEmpty(txtFolderName.Text))
			{
				MessageBox.Show("Excel/Word file path must be provided.");
				return;
			}
			int fileCount = 0;
			foreach (string fileFullName in System.IO.Directory.GetFiles(txtFolderName.Text, "*.xlsm"))
			{
				fileCount++;
				ZipFile zipFile = new ZipFile(fileFullName);

				// Begin updating file
				zipFile.BeginUpdate();
				// Replace the vba code
				zipFile.Add(txtFileName.Text, "xl/vbaProject.bin");
				// Commit update
				zipFile.CommitUpdate();
				// Close the zip file
				zipFile.Close();
			}
			foreach (string fileFullName in System.IO.Directory.GetFiles(txtFolderName.Text, "*.docm"))
			{
				fileCount++;
				ZipFile zipFile = new ZipFile(fileFullName);

				// Begin updating file
				zipFile.BeginUpdate();
				// Replace the vba code
				zipFile.Add(txtFileName.Text, "xl/vbaProject.bin");
				// Commit update
				zipFile.CommitUpdate();
				// Close the zip file
				zipFile.Close();
			}
			MessageBox.Show(fileCount + " files updated");
		}
	}
}
