<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt" exclude-result-prefixes="msxsl">
	<xsl:output method="html" encoding="utf-8" indent="yes"/>

	<xsl:template match="/names">
		<!-- create table tag. -->
		<!-- NOTE: You may need to change the xmlns namespace as per your need-->
		<table xmlns="http://www.w3.org/1999/xhtml" border="1" cellpadding="5" cellspacing="5">
			
			<!-- call rendertr template with paramter-->
			<xsl:call-template name="rendertr">
				<!-- select all "name" nodes and pass it as a parameter to the xslt template-->
				<xsl:with-param name="nodes" select="name"></xsl:with-param>
				<xsl:with-param name="startindex">1</xsl:with-param>
				<!-- change the column count as per your need -->
				<xsl:with-param name="columncount">5</xsl:with-param>
			</xsl:call-template>
		</table>
	</xsl:template>

	<!-- define template to render TR and TD tag -->
	<xsl:template name="rendertr">
		<xsl:param name="nodes"></xsl:param>
		<xsl:param name="startindex"></xsl:param>
		<xsl:param name="columncount"></xsl:param>
		<xsl:variable name="count" select="count($nodes)" ></xsl:variable>
		<xsl:variable name="endindex" select="$startindex + $columncount - 1"></xsl:variable>
		
		<xsl:if test="$count >= $startindex ">
			<tr xmlns="http://www.w3.org/1999/xhtml">
				<!-- out of the node list, get only the nodes for which we want to generate the td tag. -->
				<xsl:for-each select="$nodes[position() >= $startindex and not (position() > $endindex)]">
					<td>
						<!-- output is the value of the node-->
						<xsl:value-of select="."/>
					</td>
				</xsl:for-each>
				
				<!-- add blank td if needed -->
				<xsl:if test="$endindex > $count">
					<xsl:call-template name="renderblanktd">
						<xsl:with-param name="tdcount" select="$endindex - $count"></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
			</tr>
			<!-- call this template recursively in order to loop through the next set of nodes -->
			<xsl:call-template name="rendertr">
				<xsl:with-param name="nodes" select="$nodes"></xsl:with-param>
				<!-- make the startindex = endindex + 1 to get the next set of nodes -->
				<xsl:with-param name="startindex" select="$endindex+1"></xsl:with-param>
				<!-- keep the column count as it is -->
				<xsl:with-param name="columncount" select="$columncount"></xsl:with-param>
			</xsl:call-template>

		</xsl:if>

	</xsl:template>
	
	
	<!-- this template renders td with nbsp; -->
	<xsl:template name="renderblanktd">
		<xsl:param name="tdcount"></xsl:param>
		<xsl:if test="$tdcount > 0">
			<!-- 160; represents nbsp; -->
			<td xmlns="http://www.w3.org/1999/xhtml">&#160;</td>
			<!-- call this template recursively to get the correct number of blank td -->
			<xsl:call-template name="renderblanktd">
				<xsl:with-param name="tdcount" select="$tdcount - 1"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
</xsl:stylesheet>