#!C:/Program Files/Python27/python.exe

# Copyright 2009 Corey Trager
# Distributed under the terms of the GNU General Public License
# Modified by Vishal Monpara (http://www.vishalon.net)
# Modification under terms of the GNU General Public License

import sys
import subprocess
import re
import urllib
import os
from xml.dom.minidom import parseString


# FOR ORIGINAL FILE, PLEASE REFER THE FILE THAT WAS DOWNLOADED WITH
# BUGTRACKER.NET. THIS FILE IS HEAVILY MODIFIED

#######################################################################
# 1. Change the first line of the script to point to the python.exe
#    on your local machine. Each machine has different installation path
# 2. If you have customized admin password, change the variable
#    "btnet_password" value. Alternatively, you may want to create a
#    separate user dedicated for this script
# 3. Change the mercurial installation path by changing the variable
#    "hg_path" value. Please note that a space character in the path
#    requires whole path to be enclosed in double quote characters.
# 4. Once everything is working, you may want to turn off debugging
#    by setting the variable "bDebug" to False.
#######################################################################


# BugTracker.NET username and password.  The username needs to match
# a setting in Web.config.

btnet_username = "admin"
btnet_password = "admin"

# The path to the hg executable
hg_path = "\"C:\\Program Files\\TortoiseHg\\hg.exe\""


# The URL needs to be reachable from the machine where this script is
# running.  (I have a virtual directory named "btnet").  Don't
# use IIS windows security on hg_hook.aspx.
btnet_url = "http://localhost/bugtracker/hg_hook.aspx"

# Path to repository.  BugTracker.NET web pages will use this.
this_repository_url = os.getcwd()

# 

bDebug = True

#######################################################################
#
# !!!   End of stuff you need to change
#
#######################################################################


#######################################################################
# for debugging
#######################################################################
def debug_out(s):
	if (bDebug):
		f = open((os.environ["TEMP"]) + '\\btnet_hg_hook_log.txt', 'a')
		f.write(s)
		f.write('\n')
		f.close	
		print s

#######################################################################
#
# This is where this script keeps track of previously processed
# commits. If you delete this file, this script will send log info
# for ALL commits to BugTracker.NET.  You might want to do that to
# reload the hg_revisions and hg_affected_paths tables.
#
#######################################################################
prev_commit_file = this_repository_url + "\\.hg\\btnet_prev_commit.txt"
debug_out(prev_commit_file)

#######################################################################
# Get the log info from hg.
# If we've already fetched info in the past, just fetch the info
# since the last commit
#######################################################################

# get the previous commit
try:
	most_recent_commit_file = open(prev_commit_file,"r")
	prev_commit = most_recent_commit_file.read(40)
	most_recent_commit_file.close() 
except:
	prev_commit = ""

debug_out("prev_commit")
debug_out(prev_commit)

cmd = hg_path + " log --style btnet"

# just since previously processed commit
if prev_commit != "":
	cmd += " -r " + prev_commit + ":"

debug_out(cmd)

process = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
debug_out("log stdout:")
log_string = process.stdout.read()
debug_out(log_string)
debug_out("stderr:")
debug_out(process.stderr.read())

# remember that we already processed this commit, for next time

dom = parseString("<root>" + log_string + "</root>") 
nodes = dom.getElementsByTagName("changeset")
debug_out("nodes.length")
debug_out(str(nodes.length))
if nodes.length > 0:
	hg_node = nodes[nodes.length-1].getAttribute("node")
	debug_out("prev_commit")
	debug_out(hg_node)
	most_recent_commit_file = open(prev_commit_file,"w")
	most_recent_commit_file.write(hg_node)
	most_recent_commit_file.close()


# get the first commit in the log string and save it to the file.

#######################################################################
# send an http request to BugTracker.NET
#######################################################################

params = urllib.urlencode({
	'hg_log': log_string,
	'repo': this_repository_url,
	'username': btnet_username,
	'password': btnet_password})

debug_out("Trying to push change to bugtracker.net")
response = urllib.urlopen(btnet_url, params)
data = response.read()
debug_out("Website Response Data")
debug_out(data)
